org 100h

%define XRES 320
%define YRES 200
%define VESA_MODE 0x10e

;%define XRES 640
;%define YRES 480
;%define VESA_MODE 0x111

;%define XRES 1024
;%define YRES 768
;%define VESA_MODE 0x117

;scratch

; zeroed timers
T  equ $-10
T2 equ $-8
T3 equ $-6

C equ $+8
S equ $+12

;[bp+si] points here
  push 0x8000 ; table: cos
  pop ds
  push 0x7000 ; table: color_mul/cos
  pop fs
  push 0x6000 ; table: 0.5 + cos
  pop gs
  push 0xa000
  pop es      ; screen

  mov ax,0x4f02
  mov bx,VESA_MODE ; 1024x768, 65536 colors (16-bit)
  int 10h

  jmp START  ; bp+si
C10          dw 10
C16K_DIV_2PI dw 2608 ; 16384/2pi
C8K_DIV_2PI  dw 1304 ; 8192/2pi
COLOR_MUL    dw 7
CHALF        dd 0.5

START:
  xor bp,bp
%define b(xx) byte[byte bp+si+xx]
%define w(xx) word[byte bp+si+xx]
%define d(xx) dword[byte bp+si+xx]

;Cos table with 16384 entries
  fninit
COS_TAB:
  imul bx,[bp+di],4 ; bx=[ss:bp+di]=[ss:-2]=angle (0 on init)
  fild word[bp+di]
  fidiv w(C16K_DIV_2PI)
  fcos           ;; cos(angle/65536*2pi): adjust period to 2pi
  fst dword[bx]

  fld d(CHALF)
  fadd st1
  fstp dword[gs:bx] ; 0.5 + cos(...)

  fidivr w(COLOR_MUL) ;; color_mul/cos(...)
  fstp dword[fs:bx]
  inc word[bp+di] ; next angle
  jnz COS_TAB     ; bx=4

M: ; bp=0

  mov bx,w(T2)
  fld dword[bx]         ;; cos(t2)
  fidiv w(C10)          ;; cos(t2)/10
  fld1
  fsubrp st1,st0        ;; scale=1-cos(t2)/10

  mov bx,w(T)
  fld st0
  fmul dword[bx-0x4000] ;; S=sin(t)*scale scale
  fstp d(S)
  fmul dword[bx]        ;; C=cos(t)*scale
  fstp d(C)


; Pixel loop

  xor di,di
  xor dx,dx      ; dx:di = VESA window:address
  mov bp,YRES
Y:
  mov cx,XRES
X:

; Set VESA page when needed
  test di,di
  jnz NZ_DI
  mov ax,0x4f05  ; each line: set window, assume 64kB granularity
  xor bx,bx      ; bh=0 bl=window=0 dx=page
  int 10h
  inc dx
NZ_DI:

  lea ax,[word bp-YRES/2]
C_YRES_HALF equ $-2
  mov bx,-XRES/2
  add bx,cx

  pusha ; [-18-16-14-12-10 -8 -6 -4]
        ;   di si bp sp bx dx cx ax

  call IT
  popa

  stosw

  loop X ; cx=0
  dec bp
  jnz Y ; bp=0

  add w(T),41*4    ; 1/64 * 65536/2pi
  add w(T2),28*4   ; 1/64 * 65536/2pi * ln(2)
  add w(T3),59*4   ; 1/64 * 65536/2pi / ln(2)

  in al,60h ; ESC check
  cmp al,1
  jne M

IT:
; [-18-16-14-12-10 -8 -6 -4]
;   di si bp sp bx dx cx ax
;               X        Y

  xor bp,bp
  fldz
  fldz
  fldz       ; R=0 G=0 B=0

  fild word[bp-4]
  fidiv w(C_YRES_HALF) ;; y[-1..1] R G B

  fild word[bp-10]
  fidiv w(C_YRES_HALF) ;; x[-1.33..1.33] y[-1..1] R G B

  mov cx,12     ; cx = i

  call LEN
  imul di,[bp+si],4 ; di = d = 65536/2pi * length(x,y)/2

  mov ax,w(T2)
  sub ax,di
  imul ax,3       ; ax = (t2-d)*3

  sub di,w(T3)    ; di = d-t3

I:
; rotate and scale
  ;[x] = [C -S]*[x]
  ;[y]   [S  C] [y]
R fld st1         ;; y x y R G B    | x Sy x Cy R G B
  fmul d(C)       ;; Cy x y R G B   | Cx Sy x Cy R G B
  fxch st2        ;; y x Cy R G B   | x Sy Cx Cy R G B
  fmul d(S)       ;; Sy x Cy R G B  | Sx Sy Cx Cy R G B
  neg cl
  js R
  faddp st3,st0  ;; Sy Cx Sx+Cy R G B
  fsubp st1,st0  ;; x=Cx-Sy y=Sx+Cy R G B

; square fold for now
F fsub d(CHALF) ;; x=x-0.5 y=y-0.5 R G B
  fist word[bp+si]
  fisub word[bp+si]
  fxch st1
  neg cl
  js F          ;; x=x-round(x) y=y-round(y) K R G B

; interfering concentric circles
  call LEN
  imul bx,[bp+si],10*4 ; 65536/2pi * 5*length(x,y)
  fld dword[fs:bx+di] ;; k=color_mul/cos(5*length(x,y) + d - t3) x y R G B
  fld st0
  fld st0             ;; k k k x y R G B

; RGB += k * ( 0.5 + cos(3*(t2 - d + i/100) + [0 -1 -2]) );
  imul bx,cx,78*4     ; bx = q = 65536/2pi * (i/100*3
  add bx,ax           ;                       + t2*3 - d*3)

;G fmul dword[gs:bx+2*2608*4] ;; k*(0.5 * cos(q)) k k x y R G B
G fmul dword[gs:bx] ;; k*(0.5+cos(q)) k k x y R G B
  faddp st5,st0     ;; k k x y R+=k*(0.5+cos(q)) G B
  sub bh,40
  add cl,0x55       ;; x y [R G B]+=k*(0.5+cos(q+[0 -1 -2]))
  jnc G         ; cl--
  jnz I

  fcompp            ;; R G B

; RGB = RGB*RGB/256;  // square the sum for better contrast

  mov cl,6
  mov ax,1
COL:
  fmul st0
  fistp word[bp+si] ; if it's > 0x7fff, store 0x8000
  imul bx,[bp+si],2 ; double, set carry if it was > 0x3fff
  sbb bh,ch
  xor cl,5^6
  shld ax,bx,cl    ; rrrrrggggggbbbbb
  jnc COL
  
  mov [bp-4],ax
  ret


LEN: ;; x y -> [bp+si] = sqrt(x*x+y*y)*8192/2pi
  fld st1
  fmul st0
  fld st1
  fmul st0
  faddp
  fsqrt
  fimul w(C8K_DIV_2PI)
  fistp dword[bp+si]
  ret
